<?php
// navbar.php
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: login.php");
    exit;
}
$fullName = $_SESSION['full_name'] ?? $_SESSION['user'];
?>
<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
    <div class="container-fluid">
        <a class="navbar-brand" href="#">OLT Port Management</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link <?= basename($_SERVER['PHP_SELF']) === 'bigolt.php' ? 'active' : '' ?>" href="big.php">Big OLT (ODC)</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= basename($_SERVER['PHP_SELF']) === 'miniolt.php' ? 'active' : '' ?>" href="mini.php">Mini OLT</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= basename($_SERVER['PHP_SELF']) === 'microolt.php' ? 'active' : '' ?>" href="micro.php">Micro OLT</a>
                </li>
            </ul>
            <ul class="navbar-nav ms-auto">
                <li class="nav-item">
                    <span class="nav-link">Welcome, <?= htmlspecialchars($fullName) ?></span>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="logout.php">Logout</a>
                </li>
            </ul>
        </div>
    </div>
</nav>