<?php
require_once 'dbconfig.php';

$city = $_GET['city'] ?? '';

if (empty($city)) {
    echo json_encode([]);
    exit;
}

try {
    $db = getDBConnection();
    $stmt = $db->prepare("SELECT DISTINCT a.siteid, a.status, a.type_brand, a.merk 
                         FROM assetdata a
                         LEFT JOIN port_management_olt p ON a.siteid = p.siteid 
                         WHERE a.jenis2 = 'MICRO' AND a.kota = ?
                         ORDER BY a.siteid");
    $stmt->bind_param("s", $city);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $olts = [];
    while ($row = $result->fetch_assoc()) {
        $olts[] = $row;
    }
    
    echo json_encode($olts);
} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
?>