<?php
require_once 'dbconfig.php';

// Create database connection
$db = getDBConnection();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Port Management OLT</title>
    <!-- DataTables CSS -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- DataTables JS -->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <!-- Bootstrap for better styling -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .port-status {
            display: inline-block;
            padding: 3px 8px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: bold;
        }
        .port-up {
            background-color: #d4edda;
            color: #155724;
        }
        .port-down {
            background-color: #f8d7da;
            color: #721c24;
        }
        .port-other {
            background-color: #e2e3e5;
            color: #383d41;
        }
    </style>
</head>
<body>
    <div class="container mt-4">
        <h2>Port Management OLT</h2>
        <table id="portManagementTable" class="table table-striped table-bordered" style="width:100%">
            <thead>
                <tr>
                    <th>Site ID</th>
                    <th>Slot ID</th>
                    <th>Merk</th>
                    <th>Port 0</th>
                    <th>Port 1</th>
                    <th>Port 2</th>
                    <th>Port 3</th>
                    <th>Port 4</th>
                    <th>Port 5</th>
                    <th>Port 6</th>
                    <th>Port 7</th>
                    <th>Port 8</th>
                    <th>Port 9</th>
                    <th>Port 10</th>
                    <th>Port 11</th>
                    <th>Port 12</th>
                    <th>Port 13</th>
                    <th>Port 14</th>
                    <th>Port 15</th>
                    <th>Port 16</th>
                    <th>Updated By</th>
                    <th>Updated Time</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $query = "SELECT * FROM port_management_olt";
                $result = $db->query($query);
                
                if ($result->num_rows > 0) {
                    while ($row = $result->fetch_assoc()) {
                        echo "<tr>";
                        echo "<td>".htmlspecialchars($row['siteid'])."</td>";
                        echo "<td>".htmlspecialchars($row['slotid'])."</td>";
                        echo "<td>".htmlspecialchars($row['merk'])."</td>";
                        
                        // Display port status with styled indicators
                        for ($i = 0; $i <= 16; $i++) {
                            $portValue = isset($row["port$i"]) ? strtolower($row["port$i"]) : '';
                            $statusClass = '';
                            $displayValue = $portValue;
                            
                            if (strpos($portValue, 'up') !== false || $portValue === 'active') {
                                $statusClass = 'port-up';
                                $displayValue = 'UP';
                            } elseif (strpos($portValue, 'down') !== false || $portValue === 'inactive') {
                                $statusClass = 'port-down';
                                $displayValue = 'DOWN';
                            } else {
                                $statusClass = 'port-other';
                                $displayValue = strtoupper($portValue) ?: '-';
                            }
                            
                            echo "<td><span class='port-status $statusClass'>$displayValue</span></td>";
                        }
                        
                        echo "<td>".htmlspecialchars($row['update_by'])."</td>";
                        echo "<td>".htmlspecialchars($row['updated_time'])."</td>";
                        echo "<td>
                                <button class='btn btn-sm btn-primary edit-btn' data-id='".$row['siteid']."-".$row['slotid']."'>Edit</button>
                                <button class='btn btn-sm btn-danger delete-btn' data-id='".$row['siteid']."-".$row['slotid']."'>Delete</button>
                              </td>";
                        echo "</tr>";
                    }
                }
                ?>
            </tbody>
        </table>
        <button id="addNewBtn" class="btn btn-success">Add New OLT</button>
    </div>

    <!-- Modal for Add/Edit -->
    <div class="modal fade" id="oltModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalTitle">Add New OLT</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="oltForm">
                        <input type="hidden" id="editId" name="editId" value="">
                        <div class="row mb-3">
                            <div class="col-md-4">
                                <label for="siteid" class="form-label">Site ID</label>
                                <input type="text" class="form-control" id="siteid" name="siteid" required>
                            </div>
                            <div class="col-md-4">
                                <label for="slotid" class="form-label">Slot ID</label>
                                <input type="text" class="form-control" id="slotid" name="slotid" required>
                            </div>
                            <div class="col-md-4">
                                <label for="merk" class="form-label">Merk</label>
                                <input type="text" class="form-control" id="merk" name="merk" required>
                            </div>
                        </div>
                        
                        <div class="row mb-3">
                            <h6>Port Status</h6>
                            <?php for ($i = 0; $i <= 16; $i++): ?>
                                <div class="col-md-3 mb-2">
                                    <label for="port<?php echo $i; ?>" class="form-label">Port <?php echo $i; ?></label>
                                    <select class="form-select" id="port<?php echo $i; ?>" name="port<?php echo $i; ?>">
                                        <option value="up">UP</option>
                                        <option value="down">DOWN</option>
                                        <option value="maintenance">MAINTENANCE</option>
                                        <option value="unknown">UNKNOWN</option>
                                        <option value="disabled">DISABLED</option>
                                    </select>
                                </div>
                            <?php endfor; ?>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" id="saveBtn">Save changes</button>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            // Initialize DataTable
            var table = $('#portManagementTable').DataTable({
                responsive: true,
                dom: 'Bfrtip',
                buttons: [
                    'copy', 'csv', 'excel', 'pdf', 'print'
                ]
            });
            
            // Bootstrap JS (needed for modal)
            $.getScript('https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js', function() {
                // Bootstrap loaded
            });
            
            // Add new button click
            $('#addNewBtn').click(function() {
                $('#modalTitle').text('Add New OLT');
                $('#oltForm')[0].reset();
                $('#editId').val('');
                var modal = new bootstrap.Modal(document.getElementById('oltModal'));
                modal.show();
            });
            
            // Edit button click
            $('#portManagementTable').on('click', '.edit-btn', function() {
                var id = $(this).data('id');
                var ids = id.split('-');
                var siteid = ids[0];
                var slotid = ids[1];
                
                // Fetch data via AJAX
                $.ajax({
                    url: 'get_olt_data.php',
                    method: 'POST',
                    data: {siteid: siteid, slotid: slotid},
                    dataType: 'json',
                    success: function(response) {
                        if (response.status === 'success') {
                            $('#modalTitle').text('Edit OLT');
                            $('#editId').val(id);
                            $('#siteid').val(response.data.siteid);
                            $('#slotid').val(response.data.slotid);
                            $('#merk').val(response.data.merk);
                            
                            // Set port status dropdowns
                            for (var i = 0; i <= 16; i++) {
                                var portValue = response.data['port' + i] || 'unknown';
                                $('#port' + i).val(portValue.toLowerCase());
                            }
                            
                            var modal = new bootstrap.Modal(document.getElementById('oltModal'));
                            modal.show();
                        } else {
                            alert('Error: ' + response.message);
                        }
                    },
                    error: function() {
                        alert('Error fetching data');
                    }
                });
            });
            
            // Save button click
            $('#saveBtn').click(function() {
                var formData = $('#oltForm').serialize();
                
                $.ajax({
                    url: 'save_olt.php',
                    method: 'POST',
                    data: formData,
                    success: function(response) {
                        var result = JSON.parse(response);
                        if (result.status === 'success') {
                            alert('Data saved successfully');
                            location.reload();
                        } else {
                            alert('Error: ' + result.message);
                        }
                    },
                    error: function() {
                        alert('Error saving data');
                    }
                });
            });
            
            // Delete button click
            $('#portManagementTable').on('click', '.delete-btn', function() {
                if (confirm('Are you sure you want to delete this OLT?')) {
                    var id = $(this).data('id');
                    var ids = id.split('-');
                    var siteid = ids[0];
                    var slotid = ids[1];
                    
                    $.ajax({
                        url: 'delete_olt.php',
                        method: 'POST',
                        data: {siteid: siteid, slotid: slotid},
                        success: function(response) {
                            var result = JSON.parse(response);
                            if (result.status === 'success') {
                                alert('OLT deleted successfully');
                                location.reload();
                            } else {
                                alert('Error: ' + result.message);
                            }
                        },
                        error: function() {
                            alert('Error deleting data');
                        }
                    });
                }
            });
        });
    </script>
</body>
</html>