<?php
require_once 'dbconfig.php';
header('Content-Type: application/json');

$siteid = trim($_GET['siteid'] ?? '');
if (empty($siteid)) {
    http_response_code(400);
    echo json_encode(['error' => 'Site ID is required']);
    exit;
}

try {
    $db = getDBConnection();
    
    $stmt = $db->prepare("SELECT capacity, usedcapacity FROM assetdata WHERE siteid = ? LIMIT 1");
    $stmt->bind_param("s", $siteid);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 0) {
        http_response_code(404);
        echo json_encode(['error' => 'OLT not found']);
        exit;
    }
    
    $data = $result->fetch_assoc();
    echo json_encode([
        'success' => true,
        'capacity' => (int)$data['capacity'],
        'usedcapacity' => (int)$data['usedcapacity']
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
} finally {
    if (isset($stmt)) $stmt->close();
    if (isset($db)) $db->close();
}
?>