<?php
require_once 'dbconfig.php';

header('Content-Type: application/json');

try {
    if (!isset($_GET['source_olt']) || empty($_GET['source_olt'])) {
        throw new Exception('Source OLT parameter is required');
    }

    $sourceOLT = trim($_GET['source_olt']);
    $db = getDBConnection();

    if ($db->connect_error) {
        throw new Exception('Database connection failed: ' . $db->connect_error);
    }

    // Modified query to better handle relationships
    $query = "
        SELECT DISTINCT
            IF(a.siteid = ?, p.farend, a.siteid) AS target_olt
        FROM 
            assetdata a
        JOIN 
            port_management_olt p ON a.siteid = p.siteid OR p.farend = a.siteid
        WHERE 
            (a.siteid = ? OR p.farend = ?)
            AND (p.farend IS NOT NULL AND p.farend != '')
    ";

    $stmt = $db->prepare($query);
    if (!$stmt) {
        throw new Exception('Prepare failed: ' . $db->error);
    }

    $stmt->bind_param('sss', $sourceOLT, $sourceOLT, $sourceOLT);
    
    if (!$stmt->execute()) {
        throw new Exception('Execute failed: ' . $stmt->error);
    }

    $result = $stmt->get_result();
    $connections = [];

    while ($row = $result->fetch_assoc()) {
        if (!empty($row['target_olt'])) {
            $connections[] = [
                'source_olt' => $sourceOLT,
                'target_olt' => $row['target_olt']
            ];
        }
    }

    if (empty($connections)) {
        echo json_encode(['message' => 'No connections found for this OLT']);
    } else {
        echo json_encode($connections);
    }

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
?>