<?php 
require_once 'dbconfig.php';
header('Content-Type: application/json');

$db = getDBConnection();

$siteid = $_GET['siteid'] ?? '';

// Siapkan statement untuk ambil data slot berdasarkan siteid
$stmt = $db->prepare("SELECT * FROM port_management_olt WHERE siteid = ? ORDER BY slotid");
$stmt->bind_param("s", $siteid);
$stmt->execute();
$result = $stmt->get_result();

// Ambil semua status dari assetdata
$assetStatus = [];
$assetResult = $db->query("SELECT siteid, status FROM assetdata WHERE siteid LIKE '{$siteid}%'");
while ($row = $assetResult->fetch_assoc()) {
    $assetStatus[$row['siteid']] = $row['status'];
}

$slotsData = [];

while ($row = $result->fetch_assoc()) {
    // Loop dari port0 hingga port16
    for ($i = 0; $i <= 16; $i++) {
        $portKey = "port$i";
        $portSiteId = $row[$portKey];

        // Ambil status dari cache assetStatus jika ada
        $status = isset($assetStatus[$portSiteId]) ? $assetStatus[$portSiteId] : null;
        $row["status$i"] = $status;
    }

    $slotsData[$row['slotid']] = $row;
}

echo json_encode($slotsData);

$stmt->close();
$db->close();
?>
