<?php
require_once 'dbconfig.php';

$siteid = $_GET['siteid'] ?? '';

$db = getDBConnection();
$stmt = $db->prepare("SELECT lat, lng FROM assetdata WHERE siteid = ?");
$stmt->bind_param("s", $siteid);
$stmt->execute();
$result = $stmt->get_result();

$location = ['lat' => null, 'lng' => null];
if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $location['lat'] = $row['lat'];
    $location['lng'] = $row['lng'];
}

header('Content-Type: application/json');
echo json_encode($location);

$stmt->close();
$db->close();
?>